//---------------------------------------------------------------------------------------
//  FILE:    X2Effect_DLC_3SacrificeShield.uc
//  AUTHOR:  Joshua Bouscher
//           
//---------------------------------------------------------------------------------------
//  Copyright (c) 2016 Firaxis Games, Inc. All rights reserved.
//---------------------------------------------------------------------------------------
class X2Effect_Backlash extends X2Effect_Persistent config(GameData_SoldierSkills);

var config array<name> IgnoreDamageTypes;       //  effects with the listed damage type will be allowed to hit the original target
var config array<name> IgnoreAbilities;         //  abilities listed here will be allowed to hit the original target

function bool ChangeHitResultForTarget(XComGameState_Effect EffectState, XComGameState_Unit Attacker, XComGameState_Unit TargetUnit, XComGameState_Ability AbilityState, bool bIsPrimaryTarget, const EAbilityHitResult CurrentResult, out EAbilityHitResult NewHitResult)
{
	local X2Effect SourceEffect;

	//	don't change a natural miss
	if (!class'XComGameStateContext_Ability'.static.IsHitResultHit(CurrentResult))
		return false;


	if ((TargetUnit.GetCurrentStat(eStat_ShieldHP) > 0 ) && TargetUnit.IsAbleToAct())
	{
	
		NewHitResult = eHit_Reflect;
		TargetUnit.SetCurrentStat(eStat_ShieldHP, (TargetUnit.GetCurrentStat(eStat_ShieldHP) - 1));
		return true;
		
	}
	
	return false;
}



DefaultProperties
{
	EffectName="BioticBacklash"
	DuplicateResponse=eDupe_Ignore
}